/*
 * rgb2ycrcb.c
 *
 *  Created on: 2014/06/19
 *  Copyright 2014 The 2nd ARC/CPSY/RECONF High-Performance Computer System Design Contest
 */

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <limits.h>
#include "image.h"
#include "codec.h"
#include "bmp.h"
#include "addressmap.h"
int verbose = 0; // 1: verbose message


int main(int argc, char** argv) {
  ImageData *img_rgb   = malloc(0x1000000);
  ImageData *img_ycrcb = malloc(0x1000000);
  
  if(argc!=3) {
    printf("usage: bmp2ycrcb inputfile[rgb.bmp] outputfile[ycrcb.bmp]\n");
    exit(-1);
  }

  init_platform();
  init_addressmap();

  char* inputFileName  = argv[1];
  char* outputFileName = argv[2];
  if(verbose) printf("inputFileName : %s\n", inputFileName);
  if(verbose) printf("outputFileName: %s\n", outputFileName);

  // ファイルより画像データの読み込み
  readBMPfile(inputFileName, img_rgb);
  if(verbose) printf("read bmp(rgb) completed.\n");

  createImage(img_ycrcb, img_rgb->width, img_rgb->height, img_rgb->depth);
  convert2ycrcb(img_rgb, img_ycrcb);

  writeBMPfile(outputFileName, img_ycrcb);
  if(verbose) printf("write bmp(ycrcb) completed.\n");

  free(img_rgb);
  free(img_ycrcb);
  return 0;
}
