/*
 * communication.c
 *
 *  Created on: 2014/06/19
 *  Copyright 2014 The 2nd ARC/CPSY/RECONF High-Performance Computer System Design Contest
 */

#include "communication.h"
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <string.h>

int sock = 0;
struct sockaddr_in addr;
struct sockaddr from;

void mylib_recvKB(int* data, int sizeKB)
{
  int i;
  int size=sizeKB*1024; // 64KB
  char* buf = (char*) data;
  int sockaddr_size = sizeof(struct sockaddr);

  printf("Waiting recv %dKB at %08x\r\n", sizeKB, (int) buf);
  
  if(sock==0) {
    sock = socket(AF_INET, SOCK_DGRAM, 0);
  
    addr.sin_family = AF_INET;
    addr.sin_port = htons(8100);
    addr.sin_addr.s_addr = INADDR_ANY;
  }
  
  bind(sock, (struct sockaddr *)&addr, sizeof(addr));

  //printf("sock addr.sin_addr=%x\n", addr.sin_addr);
  {
    int total_len = 0;
    int len;
    while(1) {
      memset(buf, 0, 1024);
      len = recvfrom(sock, buf, 1024, 0, (struct sockaddr*) &from, &sockaddr_size);
      if(len<0) {
	printf("mylib_recvKB error!(%d)\n", len);
      }
      total_len+=len;
      buf+=len;
      //printf("recv %x bytes\n", total_len);
      if(total_len >= size) break;
    }
  }
}

void mylib_sendKB(int* data, int sizeKB) {
  int i;
  printf("send %dKB from %x\r\n", sizeKB, (int) data);
  int size=sizeKB*1024/4; // 64KB
  char* buf = (char*) data;

  //sock = socket(AF_INET, SOCK_DGRAM, 0);
  //  printf("sock from.sin_addr=%x\n", from.sin_addr);

  for(i=0; i<sizeKB; i++) {
    sendto(sock, buf, 1024, 0, (struct sockaddr *)&from, sizeof(from));
    buf+=1024;

    usleep(10);
  }
}
