/*
 * fileio.c
 *
 *  Created on: 2014/06/19
 *  Copyright 2014 The 2nd ARC/CPSY/RECONF High-Performance Computer System Design Contest
 */

#include <stdio.h>
#include <string.h>
#include "fileio.h"

/*
 * Memory File I/O functions
 */

FILE currentFile;

void Mem_setFileBaseAddress(char* base) {
	currentFile.dataBase = base;
}

int Mem_fread(unsigned char* data, int unitsize, int len, FILE *fp) {
	int i;
	int size = unitsize * len;
	for(i=0; i<len; i++){data[i]=0;}
	memcpy(data, fp->current, size);
	//printf("Mem_fread data=%x, *data=%02x%02x%02x%02x, size=%x, fp->current=%x\n",
	//		(int) data, data[0], data[1], data[2], data[3], size, (int) fp->current);

	fp->pos += size;
	fp->current += size;
	return len;
}

void Mem_fputc(char c, FILE* fp) {
	*(fp->current) = c;
	fp->pos += 1;
	fp->current += 1;
}

FILE* Mem_fopen(const char* name, const char* mode) {
	currentFile.current = currentFile.dataBase;
	currentFile.pos = 0;
	//printf("Mem_fopen dataBase=%x\n", (int) currentFile.dataBase);

	return &currentFile;
}

void Mem_fclose(FILE* fp) {
}

int   Mem_ftell(FILE* fp) {
  return fp->pos;
}

/*
 * File I/O functions
 */

int readData(unsigned char *data, int len, FILE *fp) {
	return fread(data, sizeof(char), len, fp);
}

int getLong(FILE *fp) {
	unsigned char buf[10];

	readData(buf, 4, fp);
	int value = (buf[0] << 24) | (buf[1] << 16) | (buf[2] << 8) | buf[3];
	//printf("getLong value=%x\n", value);
	return value;
}

int getShort(FILE *fp) {
	unsigned char buf[10];

	readData(buf, 2, fp);
	int value = (buf[0] << 8) | buf[1];
	//printf("getShort value=%x\n", value);
	return value;
}

unsigned int getC(FILE *fp) {
	unsigned char buf[4];

	readData(buf, 1, fp);
	unsigned int value = (buf[0] << 8) | buf[1];
	//printf("getC value=%x\n", value);
	return value;
}

int fputLong(long num, FILE *fp) {
	fputc((num >> 24) & 0xff, fp);
	fputc((num >> 16) & 0xff, fp);
	fputc((num >> 8) & 0xff, fp);
	fputc((num) & 0xff, fp);
	return 0;
}

int fputShort(signed short num, FILE *fp) {
	fputc((num >> 8) & 0xff, fp);
	fputc((num) & 0xff, fp);
	return 0;
}
