/*
 * codec.h
 * Original source from: 昌達 慶仁 著，「詳解 画像処理プログラミング」，ソフトバンククリエイティブ株式会社，2008．
 *
 *  Modified on: 2014/06/19 by
 *  The 2nd ARC/CPSY/RECONF High-Performance Computer System Design Contest
 */

#ifndef __CODEC_H_
#define __CODEC_H_

#define CONT_BITS 8

#define NNN 8
#define Nketa 3

#define C14 (181)
#define S18 (98)
#define C18 (237)
#define S38 (237)
#define C38 (98)
#define S1H (50)
#define C1H (251)
#define S5H (213)
#define C5H (142)
#define S3H (142)
#define C3H (213)
#define S7H (251)
#define C7H (50)

#define FIX_0_0816 (21) // 0.0816
#define FIX_0_1145 (29) // 0.1145
#define FIX_0_1687 (43) // 0.1687
#define FIX_0_2989 (77) // 0.2989
#define FIX_0_3312 (85) // 0.3312
#define FIX_0_3456 (88) // 0.3456
#define FIX_0_4183 (107) // 0.4183
#define FIX_0_5000 (128) // 0.5
#define FIX_0_5866 (150) // 0.5866
#define FIX_0_7145 (183) // 0.7145
#define FIX_1_4022 (359) // 1.4022
#define FIX_1_7710 (453) // 1.7710

#define ZERORUN 1000
#define NUM 1
#define EOB 1001

#define DESCALE(x,n) ((x) >> (n))
#define MULTIPLY(var, const) ((int) DESCALE((var)*(const),CONT_BITS))

void convert2ycrcb(ImageData *image_rgb, ImageData *image_ycrcb);
void convert2bmp(ImageData *image_ycrcb, ImageData *image_rgb);
int get_stream( int mx, int my, int x, int y, int *stream);
void set_stream(int mx, int my, int x, int y, int *stream, int tmp);

int getPicture(char* fileData, ImageData *img);
int writePicture(char* fileData, ImageData *img);
#endif //__CODEC_H_
