/*
 * oflow.c
 *
 *  Created on: 2014/06/19
 *  Copyright 2014 The 2nd ARC/CPSY/RECONF High-Performance Computer System Design Contest
 */

#include <stdlib.h> // for abs
#include <limits.h>
#include "addressmap.h"
#include "oflow.h"

extern OpticalFlow* oflowData;

void swap(int *x0, int *x1) {
	int tmp;
	tmp = *x0;
	*x0 = *x1;
	*x1 = tmp;
}

void drawLine(ImageData *img, int x0, int y0, int x1, int y1) {
	int deltax;
	int deltay;
	int error;
	int x, y;
	int y_step;
	Pixel color;

	color.r = 255;
	color.g = 0;
	color.b = 0;

	int is_steep = abs(y1 - y0) > abs(x1 - x0);
	if (is_steep) {
		swap(&x0, &y0);
		swap(&x1, &y1);
	}

	if (x0 > x1) {
		swap(&x0, &x1);
		swap(&y0, &y1);
	}

	deltax = x1 - x0;
	deltay = abs(y1 - y0);
	error = -(deltax / 2);
	y = y0;

	if (y0 < y1) {
		y_step = 1;
	} else {
		y_step = -1;
	}

	for (x = x0; x < x1; x++) {
		if (is_steep) {
			setPixel(img, y, x, &color);
		} else {
			setPixel(img, x, y, &color);
		}

		error = error + deltay;

		if (error >= 0) {
			y = y + y_step;
			error = error - deltax;
		}
	}

}

void initOpticalFlow(OpticalFlow* flow, int size) {
  //flow = oflowData; //(OpticalFlow *) malloc(sizeof(OpticalFlow));
	flow->num = size;
	flow->flows = oflowData + 1; //malloc(sizeof(Flow)*size);

}

void optical_flow_bm(ImageData *img0, ImageData *img1, int block_size,
		     int shift_size, int max_range, OpticalFlow *optical_flow) {
  int x0, y0;
  int mx, my;
  int x1, y1;
  int sad;
  int min_sad;
  Flow flow;
  Flow *flow_ptr;
  int num = 0;
  int i;
  
  mx = img1->width;
  my = img1->height;
  
  flow_ptr = optical_flow->flows;
  
  for (y0 = 0; y0 < my; y0 = y0 + shift_size) {
    for (x0 = 0; x0 < mx; x0 = x0 + shift_size) {
      //printf("start to find the optical flow at (%d, %d). \n", x0, y0);
      min_sad = INT_MAX;
      
      // use spiral search pattern
      //
      //     9 10 11 12
      //     8  1  2 13
      //     7  *  3 14
      //     6  5  4 15
      //    20 19 18 17
      //
      
      int move;
      int xdir, ydir;
      xdir = 1;
      ydir = -1;
      
      x1 = x0;
      y1 = y0;
      for (move = 0; move < 2 * max_range + 1; move++) {
	//printf("y start\n");
	x1 = x1;
	for( i=0; i<=move; i++ ) {
	  if ((y1 >= 0) && (y1 < img1->height) && (x1 >= 0)
	      && (x1 < img1->width)) {
	    sad = get_sad(img0, img1, block_size, x0, y0, x1, y1);
	    //printf("sad:%d, ",sad);
	    /*
	      printf("sad '%d': (%d, %d), (%d, %d), flow:(%d, %d)\n",
	      sad, x0, y0, x1, y1, x1-x0, y1-y0);
	    */
	    if ((sad < min_sad)) {
	      min_sad = sad;
	      flow.x0 = x0;
	      flow.y0 = y0;
	      flow.x1 = x1;
	      flow.y1 = y1;
	    }
	  }
	  y1 =y1 + ydir;
	}
	
	//printf("x start\n");
	//y1 = y1;
	for(i=0; i<=move; i++) {
	  if ((y1 >= 0) && (y1 < img1->height) && (x1 >= 0)
	      && (x1 < img1->width)) {
	    sad = get_sad(img0, img1, block_size, x0, y0, x1, y1);
	    //printf("sad:%d, ",sad);
	    /*
	    printf("sad '%d': (%d, %d), (%d, %d), flow:(%d, %d)\n",
		   sad, x0, y0, x1, y1, x1-x0, y1-y0);
	    */
	    if ((sad < min_sad)) {
	      min_sad = sad;
	      flow.x0 = x0;
	      flow.y0 = y0;
	      flow.x1 = x1;
	      flow.y1 = y1;
	    }
	  }
	  x1 = x1 + xdir;
	}
	xdir = -xdir;
	ydir = -ydir;
	
      }
      if ((flow.x0 != flow.x1) || (flow.y0 != flow.y1)) {
	flow_ptr->x0 = flow.x0;
	flow_ptr->y0 = flow.y0;
	flow_ptr->x1 = flow.x1;
	flow_ptr->y1 = flow.y1;
	flow_ptr++;
	num++;
	/*
	  printf("the flow is from (%d, %d), to (%d, %d). vec:(%d, %d)\n",
	  flow.x0, flow.y0, flow.x1, flow.y1,
	  flow.x1-flow.x0, flow.y1-flow.y0);
	  printf("img0, x:%d, y:%d, block size:%d\n", x0, y0, block_size);
	  print_image_block_data(img0, block_size, x0, y0);
	  printf("img1, x:%d, y:%d, block size:%d\n", x1, y1, block_size);
	  print_image_block_data(img1, block_size, x1, y1);
	  printf("\n\n");
	*/
      }
      
    }
  }
  optical_flow->num = num;
}

int get_sad(ImageData *img0, ImageData *img1, int block_size, int img0_x,
		int img0_y, int img1_x, int img1_y) {

	int x0, y0, x1, y1;
	int mx0, my0;
	//int mx1, my1;
	int sad = 0;
	Pixel pix0, pix1;

	mx0 = img0_x + block_size;
	my0 = img0_y + block_size;
	//mx1 = img1_x + block_size;
	//my1 = img1_y + block_size;

	for (y0 = img0_y, y1 = img1_y; y0 < my0; y0++, y1++) {
		if ((y0 < img0->height) && (y1 < img1->height)) {
			for (x0 = img0_x, x1 = img1_x; x0 < mx0; x0++, x1++) {
				if ((x0 < img0->width) && (x1 < img1->width)) {
					getPixel(img0, x0, y0, &pix0);
					getPixel(img1, x1, y1, &pix1);
					sad = sad + abs(pix0.r - pix1.r) + abs(pix0.g - pix1.g)
							+ abs(pix0.b - pix1.b);
				}
			}
		}
	}

	return sad;
}

