/*
 * image.c
 * Original source from: 昌達 慶仁著，「詳解 画像処理プログラミング」，ソフトバンククリエイティブ株式会社，2008．
 *
 *  Modified on: 2014/06/19 by
 *  The 2nd ARC/CPSY/RECONF High-Performance Computer System Design Contest
  */

#include <stdlib.h>
#include "image.h"

void createImage(ImageData* img, int width,int height,int depth)
{
  ImageData *newimg;
  //int byte_per_pixel;

  if(width<0 || height<0) return ;
  if(depth!=8 && depth!=24) return ;
  
  newimg=img;//malloc(sizeof(ImageData));
  if(newimg==NULL) return ;
  //byte_per_pixel=depth/8;
  newimg->pixels=newimg + 1;//malloc(sizeof(BYTE)*byte_per_pixel*width*height);
  newimg->width=width;
  newimg->height=height;
  newimg->depth=depth;
}

int getPixel(ImageData *img,int x,int y,Pixel *pix)
{
  int ret=1;
  int adr;  // ��f�̉摜��̈ʒu
  int dep,val;
  BYTE *pixels;

  if(img==NULL) return -1;
  if(img->pixels==NULL) return -1;
  // �摜�O�̍��W���w�肳�ꂽ�ꍇ�̏����i�ł��߂��摜��̉�f���Q�Ƃ���j
  if(x<0) {
    x=0;
    ret=0;
  }
  if(x >= img->width ) {
    x=img->width -1;
    ret=0;
  }
  if(y<0) {
    y=0;
    ret=0;
  }
  if(y >= img->height ) {
    y=img->height -1;
    ret=0;
  }
  dep=img->depth;
  adr=x + y*img->width;
  pixels=img->pixels;
  if(dep==8) {  // �O���[�X�P�[���̏ꍇ�́ARGB���ׂĂ̓����l���Z�b�g����
    val=pixels[adr];
    pix->r=val;
    pix->g=val;
    pix->b=val;
  }
  else if(dep==24) {
    pixels+=(adr*3);
    pix->r=(*pixels);
    pixels++;
    pix->g=(*pixels);
    pixels++;
    pix->b=(*pixels);
  }
  else {
    return -1;
  }
  return ret;
}

int correctValue(int val,int max)
{
  if(val<0) return 0;
  if(val>max) return max;
  return val;
}

int setPixel(ImageData *img,int x,int y,Pixel *pix)
{
  int adr;  // ��f�̉摜��̈ʒu
  int dep;
  BYTE *pixels;

  if(img==NULL) return -1;
  if(img->pixels==NULL) return -1;
  // �摜�O�̍��W���w�肳�ꂽ��Ȃɂ����Ȃ�
  if(x<0 || x >= img->width || y<0 || y >= img->height ) {
    return 0;
  }
  dep=img->depth;
  adr=x + y*img->width;
  pixels=img->pixels;
  if(dep==8) {
    pixels[adr]=correctValue(pix->r,PIXELMAX);
  }
  else if(dep==24) {
    pixels+=(adr*3);
    (*pixels)=correctValue(pix->r,PIXELMAX);
    pixels++;
    (*pixels)=correctValue(pix->g,PIXELMAX);
    pixels++;
    (*pixels)=correctValue(pix->b,PIXELMAX);
  }
  else {
    return -1;
  }
  return 1;
}
