/*
 * communication.c
 *
 *  Created on: 2014/06/19
 *  Copyright 2014 The 2nd ARC/CPSY/RECONF High-Performance Computer System Design Contest
 */

#include "communication.h"
#include <stdio.h>
#include <xio.h>
#include <xparameters.h>

char hex2char(char hex)
{
	char c = hex<10? hex+'0' : (hex-10)+'A';
	return c;
}

void mylib_recvKB(int* data, int sizeKB)
{
	int i;
	int size=sizeKB*1024/4; // 64KB
	int val;
	printf("Waiting recv %dKB at %x\r\n", sizeKB, (int) data);
    for(i=0; i<size; i++) {
		//char buf[8];	buf[1]='\r';	buf[2]='\n';	buf[3]='\0';
    	while(1) {
    		int state = XIo_In32(XPAR_AXI_PLOADER_UART_0_BASEADDR + 0x04);
    		int data_enable = state & 1;
    		//buf[0]=state|'0';	print(buf);
    		if(data_enable==1) break;
    	}
    	val = XIo_In32(XPAR_AXI_PLOADER_UART_0_BASEADDR + 0x00);

    	// for endian exchange
    	/*{
    		char b0 = val >> 24;
    		char b1 = val >> 16;
    		char b2 = val >> 8;
    		char b3 = val >> 0;
    		val = b0 | b1<<8 | b2<<16 | b2<<24;
    	}*/
    	data[i]=val;
    }
}

void mylib_wait()
{
  volatile int sum = 0;
  int i;
  for(i=0; i<WAIT_COUNT; i++) sum += i;
}

void mylib_putchar(char c) {
	XIo_Out32(XPAR_AXI_PLOADER_UART_0_BASEADDR + 0x08,c);
	mylib_wait();
}

void mylib_sendKB(int* data, int sizeKB) {
	int i;
	printf("send %dKB from %x\r\n", sizeKB, (int) data);
	int size=sizeKB*1024/4; // 64KB
    for(i=0; i<size; i++) {
    	int val;
     	val = data[i];

     	mylib_putchar(val);
     	mylib_putchar(val>>8);
     	mylib_putchar(val>>16);
     	mylib_putchar(val>>24);
    	// for endian exchange
     	//mylib_putchar(val>>24);
     	//mylib_putchar(val>>16);
     	//mylib_putchar(val>>8);
     	//mylib_putchar(val);
    }
}
