/*
 * encoder.c
 *
 *  Created on: 2014/06/19
 *  Copyright 2014 The 2nd ARC/CPSY/RECONF High-Performance Computer System Design Contest
 */

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <limits.h>
#include "image.h"
#include "codec.h"
#include "bmp.h"
#include "addressmap.h"
int verbose=0; // 1: verbose

int main(int argc, char** argv) {
  ImageData *img = malloc(0x1000000);
  char* filedata = malloc(0x1000000);
  
  if(argc!=3) {
    printf("usage: encoder inputfile[BMP] outputfile[encoded]\n");
    exit(-1);
  }

  init_platform();
  init_addressmap();

  char* inputFileName  = argv[1];
  char* outputFileName = argv[2];
  if(verbose) printf("inputFileName : %s\n", inputFileName);
  if(verbose) printf("outputFileName: %s\n", outputFileName);

  int res = readBMPfile(inputFileName, img);
  if(verbose) printf("read bmp completed.\n");

  int writelen = writePicture(filedata ,img);
  if(verbose) printf("encode completed. %d bytes wrote\n", writelen);

  // ファイルへ画像データの書き込み
  FILE* fp = fopen(outputFileName, "wb");

  int len = fwrite(filedata, 1, writelen, fp);
  if(verbose) printf("wrote %d bytes to the file %s.\n", len, outputFileName);

  fclose(fp);
  free(img);
  free(filedata);
  return 0;
}
