/*
 * decoder.c
 *
 *  Created on: 2014/06/19
 *  Copyright 2014 The 2nd ARC/CPSY/RECONF High-Performance Computer System Design Contest
 */

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <limits.h>
#include "image.h"
#include "codec.h"
#include "bmp.h"
#include "addressmap.h"
int verbose = 0; //1: debug

int main(int argc, char** argv) {
  ImageData *img = malloc(0x1000000);
  char* filedata = malloc(0x1000000);
  
  if(argc!=3) {
    printf("usage: decoder inputfile outputfile\n");
    exit(-1);
  }

  init_platform();
  init_addressmap();

  char* inputFileName  = argv[1];
  char* outputFileName = argv[2];
  if(verbose) printf("inputFileName : %s\n", inputFileName);
  if(verbose) printf("outputFileName: %s\n", outputFileName);

  // ファイルより画像データの読み込み
  FILE* fp = fopen(inputFileName, "rb");
  int len = fread(filedata, 1, 1024*16, fp);
  if(verbose) printf("read %d bytes.\n", len);

  getPicture(filedata ,img);
  if(verbose) printf("decode completed.\n");

  writeBMPfile(outputFileName, img);
  if(verbose) printf("write bmp completed.\n");

  fclose(fp);
  free(img);
  free(filedata);
  return 0;
}
