/*
 * main.c
 *
 *  Created on: 2014/06/19
 *  Copyright 2014 The 2nd ARC/CPSY/RECONF High-Performance Computer System Design Contest
 */

#include <stdio.h>
#include <string.h>
#include "addressmap.h"
#include "image.h"
#include "codec.h"
#include "communication.h"
#include "fileio.h"
#include "oflow.h"
#include "platform.h"

#ifdef __DEBUG_ON_LINUX__
#include "bmp.h"
char debugFileName[16];
#endif //#ifdef __DEBUG_ON_LINUX__


extern int* imgFile0;
extern int* imgFile1;
extern int* imgFile2;
extern ImageData* img0;
extern ImageData* img1;
extern ImageData* oflow_img;
extern OpticalFlow* oflowData;

char bufKB[1024]; // 1KB buf
char* endMessage = "END";

/**
 * 初期化
 */
int initialize() {
  memset(bufKB, ' ', 1024);
  strncpy(bufKB, endMessage, sizeof(endMessage));
  return 0;
}

/**
 * 2つのフレームを取得・画像を展開し、オプティカルフローを計算する
 */
int calc_opticalflow(int batchID) {
  int i;
  Flow *ptr;
  
  // 2つのフレームを受信
  mylib_recvKB(imgFile0, IMAGE_SIZE_KB);
  mylib_recvKB(imgFile1, IMAGE_SIZE_KB);

  // 通信エラー確認
  //mylib_sendKB(imgFile0, IMAGE_SIZE_KB);
  //mylib_sendKB(imgFile1, IMAGE_SIZE_KB);

  getPicture((char*) imgFile0, img0);
  printf("firstFrame : finished reading/decoding img0 width=%d, height=%d\n", 
	 img0->width, img0->height);
  getPicture((char*) imgFile1, img1);
  printf("secondFrame: finished reading/decoding img1 width=%d, height=%d\n",
	 img1->width, img1->height);
  
#ifdef __DEBUG_ON_LINUX__
  sprintf(debugFileName, "%d_img0.bmp", batchID);
  printf("Img0 debugFileName=%s\n", debugFileName);
  writeBMPfile(debugFileName, img0);
  
  sprintf(debugFileName, "%d_img1.bmp", batchID);
  printf("Img1 debugFileName=%s\n", debugFileName);
  writeBMPfile(debugFileName, img1);
#endif //#ifdef __DEBUG_ON_LINUX__
  
  /* フローの個数は画素の個数と同じ分だけ用意 */
  initOpticalFlow(oflowData, (img0->width) * (img0->height));
  
  //printf("optical flow calc started.\n");
  optical_flow_bm(img0, img1, 8, 8, 8, oflowData);
  //printf("optical flow calc finished.\n");
  //write_optical_flow("3", flow);
  
  createImage(oflow_img, img0->width, img0->height, img0->depth);
  if (oflow_img == NULL) {
    printf("Fail to create image file'\n");
    return 1;
  }
  
  convert2bmp(img0, oflow_img);

  //printf("drawing optical flow\n");
  printf("The number of flows: %d\n", oflowData->num);
  //printf("the depth of image: %d\n", oflow_img->depth);
  ptr = oflowData->flows;
  for (i = 0; i < oflowData->num; i++) {
    //printf("flow vector:(%d, %d)\n", ptr->x1 - ptr->x0, ptr->y1 - ptr->y0);
    drawLine(oflow_img, ptr->x0, ptr->y0, ptr->x1, ptr->y1);
    ptr++;
  }

#ifdef __DEBUG_ON_LINUX__
  sprintf(debugFileName, "%d_oflow.bmp", batchID);
  printf("Oflow debugFileName=%s\n", debugFileName);
  writeBMPfile(debugFileName, oflow_img);
#endif //#ifdef __DEBUG_ON_LINUX__

  int len = writePicture((char*) imgFile2, oflow_img);
  //printf("The length is %d bytes.\n", len);
  mylib_sendKB(imgFile2, IMAGE_SIZE_KB*2);
  mylib_sendKB((int*) bufKB, 1);
  
  return 0;
}

/**
 * 400_oflow メイン関数
 */
int main(void) {
  int i = 410;
  init_platform();
  init_addressmap();
  initialize();
  
  while(1) {
    printf("Starting 400_oflow (batchID:%d) ===\n", i);
    
    calc_opticalflow(i);
    
    printf("Finished 400_oflow (batchID:%d) ===\n", i);
    printf("\n");
    i++;
  }
  
  cleanup_platform();
  return 0;
}
