/*
 * image.h
 * Original source from: 昌達 慶仁 著，「詳解 画像処理プログラミング」，ソフトバンククリエイティブ株式会社，2008．
 *
 *  Modified on: 2014/06/19 by
 *  The 2nd ARC/CPSY/RECONF High-Performance Computer System Design Contest
 */

#ifndef __IMAGE_H__
#define __IMAGE_H__

#define TRUE 1
#define FALSE 0
typedef unsigned char BYTE;

typedef	struct STRUCT_IMAGE{
	int width,height;
	int depth;
	void* pixels;
}ImageData;

#define PIXELMAX 255
typedef struct STRUCT_PIXEL{
	int r,g,b;
}Pixel;

void createImage(ImageData* img, int width,int height,int depth);
int getPixel(ImageData *img,int x,int y,Pixel *pix);
int setPixel(ImageData *img,int x,int y,Pixel *pix);
int correctValue(int val,int max);

#endif //#ifndef __IMAGE_H__
