/*
 * fileio.h
 *
 *  Created on: 2014/06/19
 *  Copyright 2014 The 2nd ARC/CPSY/RECONF High-Performance Computer System Design Contest
 */


#ifndef FILEIO_H_
#define FILEIO_H_

#define FILE MemFile
#define fputc  Mem_fputc
#define fread  Mem_fread
#define fclose Mem_fclose
#define fopen  Mem_fopen
#define ftell  Mem_ftell

typedef struct MEM_FILE {
	char* dataBase;
	int pos;
	char* current;
} MemFile;

void Mem_setFileBaseAddress(char* base);

int   Mem_fread(unsigned char* data, int unitsize, int len, FILE *fp);
void  Mem_fputc(char c, FILE* fp);
FILE* Mem_fopen(const char* name, const char* mode);
void  Mem_fclose(FILE* fp);
int   Mem_ftell(FILE* fp);

int readData(unsigned char *data, int len, FILE *fp);
int getLong(FILE *fp);
int getShort(FILE *fp);
unsigned int getC(FILE *fp);
int fputLong(long num, FILE *fp);
int fputShort(signed short num, FILE *fp);


#endif /* FILEIO_H_ */
