/*
 * oflow.h
 *
 *  Created on: 2014/06/19
 *  Copyright 2014 The 2nd ARC/CPSY/RECONF High-Performance Computer System Design Contest
 */

#ifndef OFLOW_H_
#define OFLOW_H_

#include "image.h"

typedef struct STRUCT_OPTICAL_FLOW {
  int num;
  void *flows;
} OpticalFlow;

typedef struct STRUCT_FLOW  {
  int x0, y0, x1, y1;
} Flow;

void initOpticalFlow(OpticalFlow* flow, int size);
void optical_flow_bm(ImageData *img0, ImageData *img1,
		     int block_size, int shift_size,
		     int max_range, OpticalFlow *flow);
int get_sad(ImageData *img0, ImageData *img1,
	    int block_size, int img0_x, int img0_y,
	    int img1_x, int img1_y);
void write_optical_flow(char *name, OpticalFlow *flow);
void drawLine( ImageData *img, int x0, int y0, int x1, int y1 );
void swap( int *x0, int *x1 ) ;


#endif /* OFLOW_H_ */
