/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.utsunomiya.is;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class UDP_Client
extends Thread {
    protected final int BUF_SIZE = 1024;
    protected byte[] sendBuf = new byte[1024];
    protected byte[] recvBuf = new byte[1024];
    protected boolean verbose = true;
    protected DatagramSocket udpSocket;
    protected DatagramPacket udpPacketSend = null;
    protected DatagramPacket udpPacketRecv = new DatagramPacket(this.sendBuf, 1024);
    protected InetAddress udpDstAddress;
    protected InetAddress udpSrcAddress;
    protected int udpDstPort;
    protected int udpSrcPort;
    protected boolean fileout = true;
    protected String LogToUDP = "ToUDP.bin";
    protected String LogFromUDP = "FromUDP.bin";
    private String dataFileName;
    String targetHost;
    int targetPort;
    boolean running;

    public UDP_Client(String targetHost, int targetPort, String filename) {
        this.targetHost = targetHost;
        this.targetPort = targetPort;
        this.dataFileName = filename;
        try {
            this.udpSocket = new DatagramSocket();
            this.udpDstAddress = InetAddress.getByName(targetHost);
            this.udpDstPort = targetPort;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void reset() {
        try {
            System.out.println("Sending reset packet to " + this.udpDstAddress + " " + this.udpDstPort);
            this.sendBuf = new byte[16];
            DatagramPacket sendInitPacket = new DatagramPacket(this.sendBuf, 16, this.udpDstAddress, this.udpDstPort);
            this.udpSocket.send(sendInitPacket);
            Thread.sleep(100L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void run() {
        try {
            this.udpSocket = new DatagramSocket();
            this.udpSrcAddress = this.udpSocket.getLocalAddress();
            this.udpSrcPort = this.udpSocket.getLocalPort();
            System.out.println("UDP Socket created. sending file '" + this.dataFileName + "' started!");
            Forward f = new Forward();
            Backward b = new Backward();
            long before = System.nanoTime();
            f.start();
            b.start();
            f.join();
            b.join();
            long after = System.nanoTime();
            System.out.println();
            System.out.println("finished!");
            System.out.println("after-before = " + (after - before) + " (ns) = " + (double)(after - before) / 1.0E9 + "(s)");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        if (args.length < 1 || args.length > 2) {
            System.out.println("usage: java jp.ac.utsunomiya.is.UDP_Client targetHost [fileName]");
            System.out.println("example(1): java jp.ac.utsunomiya.is.UDP_Client 192.168.10.64 310sort512.bin");
            System.out.println("example(2): java jp.ac.utsunomiya.is.UDP_Client 192.168.10.64 ");
            System.out.println("(2) for all the application (sort, mm, stencil, spath).");
            System.exit(-1);
        }
        String targetHost = args[0];
        int targetPort = 8100;
        System.out.println("targetHost:" + targetHost + " targetPort:" + targetPort);
        if (args.length == 1) {
            new UDP_Client(targetHost, targetPort, "").reset();
            new UDP_Client(targetHost, targetPort, "310sort512.bin").run();
            new UDP_Client(targetHost, targetPort, "").reset();
            new UDP_Client(targetHost, targetPort, "320mm512.bin").run();
            new UDP_Client(targetHost, targetPort, "").reset();
            new UDP_Client(targetHost, targetPort, "330stencil512.bin").run();
            new UDP_Client(targetHost, targetPort, "").reset();
            new UDP_Client(targetHost, targetPort, "340spath512.bin").run();
        } else {
            new UDP_Client(targetHost, targetPort, "").reset();
            new UDP_Client(targetHost, targetPort, args[1]).run();
        }
    }

    class Backward
    extends Thread {
        protected FileOutputStream fileFromUDP = null;

        Backward() {
        }

        public void run() {
            int length = 0;
            try {
                try {
                    if (UDP_Client.this.fileout) {
                        this.fileFromUDP = new FileOutputStream(UDP_Client.this.LogFromUDP);
                    }
                    UDP_Client.this.running = true;
                    block11: while (UDP_Client.this.running) {
                        DatagramPacket recvPacket = new DatagramPacket(UDP_Client.this.recvBuf, 1024);
                        UDP_Client.this.udpSocket.setSoTimeout(600000);
                        UDP_Client.this.udpSocket.receive(recvPacket);
                        length = recvPacket.getLength();
                        if (length < 0) {
                            throw new IOException("Socket read failed code=" + length);
                        }
                        if (length == 0) continue;
                        if (UDP_Client.this.fileout) {
                            this.fileFromUDP.write(UDP_Client.this.recvBuf);
                        }
                        int c0 = 32;
                        int c1 = 32;
                        int c2 = 32;
                        int i = 0;
                        while (i < length) {
                            char c = (char)UDP_Client.this.recvBuf[i];
                            if (UDP_Client.this.verbose && c != '\u0000') {
                                System.out.print(c);
                            }
                            c0 = c1;
                            c1 = c2;
                            c2 = c;
                            if (c0 == 69 && c1 == 78 && c2 == 68) {
                                UDP_Client.this.running = false;
                                continue block11;
                            }
                            ++i;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (UDP_Client.this.fileout) {
                            this.fileFromUDP.close();
                        }
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    if (UDP_Client.this.fileout) {
                        this.fileFromUDP.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    class Forward
    extends Thread {
        protected FileOutputStream fileToUDP = null;

        Forward() {
        }

        public void run() {
            int length = 1024;
            FileInputStream fileData = null;
            try {
                try {
                    int ret;
                    if (UDP_Client.this.fileout) {
                        this.fileToUDP = new FileOutputStream(UDP_Client.this.LogToUDP);
                    }
                    fileData = new FileInputStream(UDP_Client.this.dataFileName);
                    int index = 0;
                    while ((ret = fileData.read(UDP_Client.this.sendBuf, 0, length)) >= 0) {
                        if (UDP_Client.this.fileout) {
                            this.fileToUDP.write(UDP_Client.this.sendBuf);
                        }
                        DatagramPacket sendPacket = new DatagramPacket(UDP_Client.this.sendBuf, length, UDP_Client.this.udpDstAddress, UDP_Client.this.udpDstPort);
                        UDP_Client.this.udpSocket.send(sendPacket);
                        if (++index % 64 == 0) {
                            System.out.println(String.valueOf(index) + "KB sent");
                        }
                        Thread.sleep(50L);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        fileData.close();
                        if (UDP_Client.this.fileout) {
                            this.fileToUDP.close();
                        }
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    fileData.close();
                    if (UDP_Client.this.fileout) {
                        this.fileToUDP.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

